function rpp = rpp_sol_info(sub_type)
%RPP_SOL_INFO   Construct COLL solution information structure.
%
% RPP = RPP_SOL_INFO(SUB_TYPE)
%
% This function is part of the toolbox developers interface and should
% typically not be used directly.
%
% Construct a solution information structure appropriate for the subtype
% passed in SUB_TYPE, which may be omitted or empty to set the branch type
% to 'segs'. There are currently no valid sub types. The solution
% information structure is appended to the ode toolbox information and used
% by RPP_READ_SOLUTION to determine what information is stored for a
% solution point.
%
% See also: RPP_READ_SOLUTION, ODE_ADD_TB_INFO

% Copyright (C) Frank Schilder, Harry Dankowicz
% Modified function references: James Hannam, Bernd Krauskopf, Hinke M. Osigna
% $Id: rpp_sol_info.m 2020-11-26 14:50 NZDT$

rpp.format = 'rpp.v1';
if nargin<1 || isempty(sub_type)
  rpp.branch_type = 'segs';
else
  rpp.branch_type = [ 'segs.' sub_type ];
end
end
