function data = rpp_init_data(prob, src_data, oid, varargin) %#ok<INUSL>
%RPP_INIT_DATA   Initialize 'rpp' instance data structure.
%
% DATA = RPP_INIT_DATA(PROB, SRC, OID, VARARGIN)
% VARARGIN = { [NAME]... }
%
% This function is part of the toolbox developers interface and should
% typically not be used directly.
%
% Construct 'rpp' instance data structure and initialize with phases of
% phase points to be located
%
% Input arguments:
%
% PROB     : Continuation problem structure.
% SRC_DATA : Source data structure.
% OID      : Object identifier of 'rpp' toolbox instance.
% VARARGIN : List of toolbox field names to copy or initialize.
%
% On return, DATA contains the following fields:
%
% oid       : Object identifier, set to OID.
% pnames    : List of parameter names.
% theta     : List of phases for phase points to be located.
% no_save   : List of field names to be excluded by coco_save_data.
%
% and any fields with names listed in VARARGIN.
%
% The fields pnames and theta are copied from the source data structure
% SRC_DATA and must be present. Any fields with names passed in VARARGIN
% are either copied from SRC_DATA if a field with this name is present in
% SRC_DATA, or initialized to the empty structure. The field no_save is
% initialized to the empty set and collects names of fields to be omitted
% by the slot function COCO_SAVE_DATA. The constructed data structure DATA
% is a protected instance of COCO_FUNC_DATA.
%
% See also ODE_SETTINGS, COCO_SAVE_DATA, COCO_FUNC_DATA.

%   % Copyright (C) James Hannam, Bernd Krauskopf, Hinke M. Osigna
%   $Id: rpp_init_data.m 2020-11-26 14:55 NZDT$

data = coco_func_data('protect');
data.oid = oid;

fields = varargin;
for i=1:numel(fields)
  field = fields{i};
  if isfield(src_data, field)
    data.(field) = src_data.(field);
  else
    data.(field) = struct();
  end
end


data.xdim    = src_data.xdim;
data.pnames  = src_data.pnames;
data.theta   = src_data.theta;
data.mode    = src_data.mode;
% change data.zpp to true/false, and store runid
if isempty(src_data.zpp)
  data.zpp = 0;
else
  data.zpp   = 1;
  data.runid = src_data.zpp;
end
% define defualt variable names if not supplied in '-rpp_par'
if isempty(src_data.rpp_par)
  if data.zpp
    dum = 'x0_';
  else
    dum = 'gama_';
  end
  axis = cell(1,data.xdim);
  for i = 1:(data.xdim)
     axis{i}   = sprintf('%s%s', dum, num2str(i));
  end
  data.rpp_par = [ {'theta', 'phi0', 'phith', 'THETA'}, axis ];
else    % if variable names are supplied, use those instead
  data.rpp_par = src_data.rpp_par;
end
data.nsegs  = src_data.nsegs;
data.no_save = {};

end
