function [seg2_args, seg1_args, opts] = rpp_init_args(arg_stream)

% extract intial solution data, get function handles; 'reverse time' and
% flip solution to match the flow
grammar   = 'F [DFDX [DFDP [DFDT [DFDXDX [DFDXDP [DFDPDP [DFDTDX [DFDTDP [DFDTDT]]]]]]]]] T0 X0 [PNAMES] P0 [THETA] [OPTS]';
args_spec = {
       'F',     '',     '@',      'fhan', [], 'read', {}
    'DFDX',     '',  '@|[]',   'dfdxhan', [], 'read', {}
    'DFDP',     '',  '@|[]',   'dfdphan', [], 'read', {}
    'DFDT',     '',  '@|[]',   'dfdthan', [], 'read', {}
  'DFDXDX',     '',  '@|[]', 'dfdxdxhan', [], 'read', {}
  'DFDXDP',     '',  '@|[]', 'dfdxdphan', [], 'read', {}
  'DFDPDP',     '',  '@|[]', 'dfdpdphan', [], 'read', {}
  'DFDTDX',     '',  '@|[]', 'dfdtdxhan', [], 'read', {}
  'DFDTDP',     '',  '@|[]', 'dfdtdphan', [], 'read', {}
  'DFDTDT',     '',  '@|[]', 'dfdtdthan', [], 'read', {}
      'T0',     '', '[num]',        't0', [], 'read', {}
      'X0',     '', '[num]',        'x0', [], 'read', {}
  'PNAMES', 'cell', '{str}',    'pnames', {}, 'read', {}
      'P0',     '', '[num]',        'p0', [], 'read', {}
   'THETA',     '', '[num]',     'theta', [], 'read', {}
  };
opts_spec = {
       '-zpp',     'zpp',    {},   'read', {}
   '-rpp_par', 'rpp_par',    {},   'read', {}
         '-u',       'u', false, 'toggle', {}
      '-var0',    'var0',    {},   'read', {}
  };

[args, opts] = coco_parse(grammar, args_spec, opts_spec, arg_stream);

[ funcs, t0, x0 ] = check_funcs( args, opts );

if opts.u || ~isempty( opts.zpp )  % set mode for rotation of backward-time periodic orbit or location of zero-phase point
  opts.mode = 1;
else  % set mode for rotation of forward-time periodic orbit
  opts.mode = 2;
end

% crate a shallow copy of arg_stream to keep extra inputs
seg1_args = coco_stream();
seg2_args = coco_stream();
for i = numel(arg_stream)
  if ~isempty(arg_stream.peek)
    seg1_args.put(arg_stream.peek);
    seg2_args.put(arg_stream.peek);
  end
  arg_stream.skip;
end
% support for two-segment rotation of periodic orbit and floquet bundle by ode_isol2flqt
if isempty(opts.var0)
  seg1_args.put(funcs{:}, t0(1), x0(1,:), args.p0);
  seg2_args.put(funcs{:}, t0, x0, args.p0);
else
  seg1_args.put(funcs{:}, t0(1), x0(1,:), args.p0, '-var', opts.var0{1}');
  seg2_args.put(funcs{:}, t0, x0, args.p0, '-var', opts.var0{2}');
end

opts.pnames = args.pnames;
opts.theta  = args.theta;

end

function [ funcs, t0, x0 ] = check_funcs( args, opts )

% reverse time to stabalise and unstable periodic orbit - F->-F, t0->flip(t0-T), x0->flip(x0)
x0    = args.x0;
t0    = args.t0;
funcs ={};    % initialise function holder
field =struct2cell(args);
if opts.u    % stabalise the unstable periodic orbit
  for i = 1:numel(field)
    if isa(field{i}, 'function_handle')
      func  = func2str(field{i});    % reconstruct function handle for clarity
      % prevent double reversing the flow when calling iscrn toolbox function inside another
      if ( numel( func ) > 7 ) && ( strcmp( func(1:7), '@(u,p)-' ) )
        funcs = [ funcs, {field{i}} ]; %#ok<AGROW>
      else
        funcs = [ funcs, {eval(['@(u,p) -',func,'(u,p)'])} ]; %#ok<AGROW>
      end
    end
  end
  % check if the direction of the flow matches the order of points in x0 -
  % if not change t0 and x0 for convergence
  y = diff(x0([1,2],:));
  y = y/norm(y);
  F = funcs{1}(x0(1,:)',args.p0);
  F = F/norm(F);
  if y*F<0
    t0 = flipud(t0(end)-t0);
    x0 = flipud(x0);
  end
else
  for i = 1:numel(field)
    if isa(field{i}, 'function_handle')
      funcs = [ funcs, {field{i}} ]; %#ok<AGROW>
    end
  end
end

end
