function prob = flqt_close_segs_theta(prob, data)
%FLQT_CLOSE_SEGS   Append an instance of 'flqt' to problem.
%
% PROB = FLQT_CLOSE_SEGS_THEAT(PROB, DATA)
%
% PROB - Continuation problem structure.
% DATA - Toolbox data structure.

%   % Copyright (C) James Hannam, Bernd Krauskopf, Hinke M. Osigna
%   $Id: flqt_close_segs_theta.m 2020-11-26 14:56 NZDT$

mu   = data.mu;
data = init_data(prob, data);
bc   = data.flqt_bc;
fid  = bc.fid;

% add constraints
nsegs   = data.nsegs;
w0_idx  = zeros(nsegs*bc.dim,1);
w1_idx  = w0_idx;
s_idx   = cell(1, nsegs);
var_oid = s_idx;
off = 0;
for i=1:nsegs
  var_oid{i}  = coco_get_id(data.cids{i}, 'var');
  [wdata, Wuidx] = coco_get_func_data(prob, var_oid{i}, 'data', 'uidx');
  dim   = wdata.xdim;
  wmaps = wdata.coll_var;
  w0_idx(off + (1:dim)') = Wuidx(wmaps.v0_idx);
  w1_idx(off + (1:dim)') = Wuidx(wmaps.v1_idx);
  off  = off + dim;
end
flo_fid  = coco_get_id(fid, 'flo');
wth_fid  = coco_get_id(fid, 'wth');
% Optional names
flqt_pnames = data.flqt_par{2};
assert(numel(flqt_pnames)==dim+1, ...
    ['%s: number of custom vector variable names supplied with -flqt_par ',...
    'must equal system dimension plus one'], coco_get_id(data.oid, flo_fid));
% choose mode for computation
idx1 = (1:dim)';  % indicies for segment 1
idx2 = dim + idx1;  % indicies for segment 2
switch data.mode
  case 1  % mode 1 - roate linear bundle of periodic orbit through
    % forward-time phase theta in a stabilised (backward-time) system
    flo_uidx = [ w0_idx(idx2); w0_idx(idx1); w1_idx(idx2); w1_idx(idx1) ];  % swap segments as realised in var_seg_bc
%     var_seg_bc_DFDU = @var_seg_bc_DFDU1;  % choose correct jacobian
    wth_uidx = w0_idx( idx1 );
  case 2  % mode 2 - rotate linear bundle of periodic orbit through
    % forward-time phase given by theta
    flo_uidx = [ w0_idx; w1_idx ];  % boundary conditions as per var_seg_bc
%     var_seg_bc_DFDU = @var_seg_bc_DFDU2;  % choose correct jacobian
    wth_uidx = w0_idx( idx2 );
end
% add monitor functions for the floquet bundle
% prob = coco_add_func(prob, flo_fid, @var_seg_bc, var_seg_bc_DFDU, data,...
prob = coco_add_func(prob, flo_fid, @var_seg_bc, data,...
         'zero', 'uidx', flo_uidx, 'u0', mu);
% add floquet bundle and multiplier as continuation parameters
mu_idx = coco_get_func_data(prob, flo_fid, 'uidx');
mu_idx = mu_idx(end);    % mu is the newest, thus last, entry to u given that it was intialised using 'u0' option of coco_add_func
prob = coco_add_pars(prob, wth_fid, [ wth_uidx; mu_idx ], flqt_pnames, 'regular');

prob = coco_add_slot(prob, fid, @coco_save_data, data, 'save_full');

end

function data = init_data(prob, data)
%INIT_DATA   Initialize toolbox data for an instance of 'flqt'.

nsegs   = data.nsegs;
fdata   = coco_get_func_data(prob, data.cids{nsegs}, 'data');
bc.dim  = fdata.xdim; % Track total dimension
bc.fhan = fdata.fhan;

idx            = (1:(bc.dim))';
bc.w0_seg1_idx =              idx;
bc.w0_seg2_idx =     bc.dim + idx;
bc.w1_seg1_idx = 2 * bc.dim + idx;
bc.w1_seg2_idx = 3 * bc.dim + idx;
bc.fid         = coco_get_id(data.oid, 'flqt');

data.flqt_bc = bc;
data.no_save = [ data.no_save, { 'flqt_bc' } ];

end

function [data, y] = var_seg_bc(~, data, u)
%VAR_SEG_BC  COC-compatable wrapper to contraints for two-segment rotation
% of a periodic orbit and its floquet bundle.
% if data.mode = 1, segments are swapped with respect to what is named here

pr = data.pr;
bc = pr.flqt_bc;

w0_seg1 = u( bc.w0_seg1_idx );
w0_seg2 = u( bc.w0_seg2_idx );
w1_seg1 = u( bc.w1_seg1_idx );
w1_seg2 = u( bc.w1_seg2_idx );
mu      = u( end );

y = [ w0_seg1 -      w1_seg2    % continuity condition
      w1_seg1 - mu * w0_seg2    % floquet condition - at phase point
     (w0_seg2)'  *  (w0_seg2) - 1];
end

function [data, J] = var_seg_bc_DFDU1(~, data, u)
%VAR_SEG_BC_DFDU1  COCO-compatable wrapper to jacobian of var_seg_bc with
% data.mode = 1, segments are swapped with respect to what is named here

pr = data.pr;
bc = pr.flqt_bc;
dim = bc.dim;

I = eye(dim);
Z = zeros(dim);
z = Z(1,:);
M = u( end ) * I;
w = transpose( 2 * u( bc.w0_seg1_idx ) );

J = [  Z, I, -I, Z;
      -M, Z,  Z, I;
       w, z,  z, z ];
end

function [data, J] = var_seg_bc_DFDU2(~, data, u)
%VAR_SEG_BC_DFDU1  COCO-compatable wrapper to jacobian of var_seg_bc with
% data.mode = 2, segments are swapped with respect to what is named here

pr = data.pr;
bc = pr.flqt_bc;
dim = bc.dim;

I = eye(dim);
Z = zeros(dim);
z = Z(1,:);
M = u( end ) * I;
w = transpose( 2 * u( bc.w0_seg2_idx ) );

J = [ I,  Z, Z, -I;
      Z, -M, I,  Z;
      z,  w, z,  z ];
end
