function prob = flqt_close_segs(prob, data)
%FLQT_CLOSE_SEGS   Append an instance of 'flqt' to problem.
%
% PROB = FLQT_CLOSE_SEGS(PROB, DATA)
%
% PROB - Continuation problem structure.
% DATA - Toolbox data structure.

%   % Copyright (C) James Hannam, Bernd Krauskopf, Hinke M. Osigna
%   $Id: flqt_close_segs.m 2020-11-26 14:56 NZDT$

data    = init_data(prob, data);
bc      = data.flqt_bc;
fid     = bc.fid;

% add constraints
nsegs    = data.nsegs;
s_idx    = cell(1, nsegs);
var_oid  = coco_get_id(data.cids{1},'var');
[fdata, uidx]  = coco_get_func_data(prob, data.cids{1}, 'data', 'uidx');
[Mdata, Muidx] = coco_get_func_data(prob, var_oid, 'data', 'uidx');
dim      = fdata.xdim;
maps     = fdata.coll_seg.maps;
x0_idx   = uidx(maps.x0_idx);
x1_idx   = uidx(maps.x1_idx);
s_idx{1} = uidx(maps.p_idx);
po_uidx  = [x0_idx; x1_idx; s_idx{1} ];
M0_idx   = Muidx(Mdata.coll_var.v0_idx,:);
po_fid   = coco_get_id(fid, 'po');
M0_fid   = coco_get_id(fid, 'M0');
M0names  = cell(1,dim^2);
% cell of names for entries to matrix of perturbations
for i = 1:dim
  for j = 1:dim
    M0names{(i-1)*dim+j} = ['M0_',num2str(i),'_',num2str(j)];
  end
end
% add periodic boundary conditions and phase condition
prob = coco_add_func(prob, po_fid, @po_bc, data, 'zero',...
    'uidx', po_uidx);
% fix initial matrix of perturbations
prob  = coco_add_pars(prob, M0_fid, M0_idx, M0names);
% Glue redundant copies of problem parameters
for k = 2:nsegs
  sfid = coco_get_id(fid, sprintf('shared%d', k-1));
  prob = coco_add_glue(prob, sfid, s_idx{1}, s_idx{k});
end
% Optional monitor functions
if ~isempty(data.pnames)
  pfid = coco_get_id(fid, 'pars');
  prob = coco_add_pars(prob, pfid, s_idx{1}, data.pnames);
end
prob = coco_add_slot(prob, fid, @coco_save_data, data, 'save_full');

end

function data = init_data(prob, data)
%INIT_DATA   Initialize toolbox data for an instance of 'rpp'.

nsegs   = data.nsegs;
fdata   = coco_get_func_data(prob, data.cids{nsegs}, 'data');
bc.dim  = fdata.xdim; % Track total dimension
bc.fhan = fdata.fhan;

bc.x0_idx = (1:bc.dim)';
bc.x1_idx = bc.dim + (1:bc.dim)';
bc.p_idx  = 2*bc.dim + (1:fdata.pdim)';

bc.fid    = coco_get_id(data.oid, 'flqt');

data.flqt_bc = bc;
data.no_save = [ data.no_save ...
  { 'flqt_bc' } ];

end

function [data, y] = po_bc(~, data, u)
%PO_BC  COCO-compatible wrapper to periodic orbit anchoring monitoring function.

pr = data.pr;
bc = pr.flqt_bc;

x0 = u(bc.x0_idx);
x1 = u(bc.x1_idx);
p  = u(bc.p_idx);

y=[ x0-x1;   % periodic orbit conditions
    [1,0]*bc.fhan(x0,p) ];    % anchor orbit to point by its flow

end
