function iscrn = iscrn_sol_info(sub_type)
%ISCRN_SOL_INFO   Construct COLL solution information structure.
%
% ISCRN = ISCRN_SOL_INFO(SUB_TYPE)
%
% This function is part of the toolbox developers interface and should
% typically not be used directly.
%
% Construct a solution information structure appropriate for the subtype
% passed in SUB_TYPE, which may be omitted or empty to set the branch type
% to 'segs'. There are currently no valid sub types. The solution
% information structure is appended to the ode toolbox information and used
% by RPP_READ_SOLUTION to determine what information is stored for a
% solution point.
%
% See also: RPP_READ_SOLUTION, ODE_ADD_TB_INFO

% Copyright (C) Frank Schilder, Harry Dankowicz
% Modified function references: James Hannam, Bernd Krauskopf, Hinke M. Osigna
%   $Id: iscrn_sol_info.m 2020-11-26 14:58 NZDT$

iscrn.format = 'iscrn.v1';
if nargin<1 || isempty(sub_type)
  iscrn.branch_type = 'seg';
else
  iscrn.branch_type = [ 'seg.' sub_type ];
end
end
