function map = iscrn_map_backward(ph)
% Outputs the correct RGB colour value for an isochron on a stable manifold
% ph: phase in [0, 1) - vector valued

%   % Copyright (C) James Hannam, Bernd Krauskopf, Hinke M. Osigna
%   $Id: iscrn_map_backward.m 2020-11-26 16:00 NZDT$

sz = size(ph);
n = max(sz);    % length of ph
if sz(2) > 1
    ph = ph';
end
ph  = mod(ph, 1);    % phase made to lie in [0, 1)
map = [ones(n, 1), 1 - 0.9 * ph, 0.2 * ones(n, 1)];

end
