function [seg1_args, opts] = iscrn_init_args(arg_stream)

% extract intial solution data, get function handles; 'reverse time' and
% flip solution to match the flow
grammar   = 'F [DFDX [DFDP [DFDT [DFDXDX [DFDXDP [DFDPDP [DFDTDX [DFDTDP [DFDTDT]]]]]]]]] T0 X0 [PNAMES] P0 S TAU_MAX [OPTS]';
args_spec = {
       'F',     '',     '@',      'fhan', [], 'read', {}
    'DFDX',     '',  '@|[]',   'dfdxhan', [], 'read', {}
    'DFDP',     '',  '@|[]',   'dfdphan', [], 'read', {}
    'DFDT',     '',  '@|[]',   'dfdthan', [], 'read', {}
  'DFDXDX',     '',  '@|[]', 'dfdxdxhan', [], 'read', {}
  'DFDXDP',     '',  '@|[]', 'dfdxdphan', [], 'read', {}
  'DFDPDP',     '',  '@|[]', 'dfdpdphan', [], 'read', {}
  'DFDTDX',     '',  '@|[]', 'dfdtdxhan', [], 'read', {}
  'DFDTDP',     '',  '@|[]', 'dfdtdphan', [], 'read', {}
  'DFDTDT',     '',  '@|[]', 'dfdtdthan', [], 'read', {}
      'T0',     '', '[num]',        't0', [], 'read', {}
      'X0',     '', '[num]',        'x0', [], 'read', {}
  'PNAMES', 'cell', '{str}',    'pnames', {}, 'read', {}
      'P0',     '', '[num]',        'p0', [], 'read', {}
       'S',     '', '[num]',         's', [], 'read', {}
 'TAU_MAX',     '', '[num]',   'tau_max', [], 'read', {}
  };
opts_spec = {
        '-arc',       'arc',    {},   'read', {}
       '-fund', 'delta_max',    {},   'read', []
  '-iscrn_par', 'iscrn_par',    {},   'read', {}
          '-u',         'u', false, 'toggle', {}
        '-psi',       'psi',    [],   'read', {}
  };

[args, opts] = coco_parse(grammar, args_spec, opts_spec, arg_stream);

[funcs, t0, x0] = iscrn_check_funcs(args, opts);

seg1_args = arg_stream.put(funcs{:}, t0, x0, args.p0);

opts.pnames  = args.pnames;
opts.s       = args.s;
opts.gamma_s = args.x0(end,:);
opts.tau_max = args.tau_max;
if ~isempty(opts.arc)  % save inital point to options of required for arc length computation
  opts.arc{end+1} = args.x0(1,:);
end

assert( ~( ~isempty( opts.psi ) && isempty( opts.delta_max ) ),...
    'Option ''-psi'' canot be specified without ''-fund''' )

if ~isempty(opts.psi)
  psi = opts.psi{1};
  if opts.u  % alter psi to account for stabilisation of system by reversing the direction of time
    psi = 1 - psi;
  end
  theta = iscrn_compute_phase(t0, x0);
  dtheta = mod(psi - theta, 1);
  psi_idx = find(t0 < dtheta * t0(end), 1, 'last');  % find 'on mesh' time of last point before gamma_psi
  t_int =  dtheta * t0(end);  % exact time at end point of gamma_psi
  t_psi = [t0(1:psi_idx); t_int];
  x_psi = [x0(1:psi_idx,:); opts.psi{3}];  % x_psi ends at gamma_psi

  % construct arguments to pass to ode_isol2coll
  opts.psi_args   = coco_stream( funcs{:}, t_psi, x_psi, args.p0 );
  % store angular difference dtheta
  opts.psi{end+1} = dtheta;
end

end
