function theta = iscrn_compute_phase( t0, x0 )
%ISCRN_COMPUTE_PHASE compute phase of periodic orbit relative to maximum in
%the its co-ordinate.

%   % Copyright (C) James Hannam, Bernd Krauskopf, Hinke M. Osigna
%   $Id: iscrn_compute_pahse.m 2020-11-26 16:01 NZDT$

T = t0(end) - t0(1);
[ ~, i ] = max( x0(:,1) );  % find zero phase on mesh
tmax_mesh = t0(i);
theta_mesh = ( T - tmax_mesh ) / T;

np = numel(t0);
% interpolation indices
if i > np - 2
  j       = 2 - np + i;
  int_idx = [(i - 2):np, 2:j+1];
  T_idx   = (6 - j):5;
elseif i < 3
  j       = 3 - i;
  int_idx = [(np - j + 1):np, 2:(i + 3)];
  T_idx   = (5 - i):5;
else
  int_idx = (i - 2):(i + 2);
  T_idx   = [];
end
t_int = t0(int_idx);  % interpolation time
t_int(T_idx) = T + t_int(T_idx);  % add period to parts of solution that wrapped around zero
x_int = x0(int_idx,:);  % interpolation time

[a, ~, mu] = polyfit(t_int, x_int(:,1), 4);  % find co-efficients of polynomial
da = (4:-1:1) .* a(1:4);  % compute coeficients of derivative
tmax = mu(2) * roots(da) + mu(1);  % construct t_max as per polyfit scalings

% find correct tmax
k = find((tmax > t_int(2)) & (tmax < t_int(4)));
if numel(k) > 1  % if more thanone candidate is found, choose tmax that gives maximal x
  [~, k] = max(polyval(a, tmax(k), [], mu));
end
tmax = tmax(k);
% compute phase
theta = ( T - tmax ) / T;
if ~isreal(theta)
  theta = theta_mesh;
  warning('Phase determined by mesh approximation')
end
theta = mod(theta, 1); % make sure that theta lies in [0,1)

end
