function [ funcs, t0, x0 ] = iscrn_check_funcs( args, opts )

% reverse time to stabalise and unstable periodic orbit - F->-F, t0->flip(t0-T), x0->flip(x0) 
x0    = args.x0;
t0    = args.t0;
funcs ={};    % initialise function holder
field =struct2cell(args);
if opts.u    % stabalise the unstable periodic orbit
  for i = 1:numel(field)
    if isa(field{i}, 'function_handle')
      func  = func2str(field{i});    % reconstruct function handle for clarity
      % prevent double reversing the flow when calling iscrn toolbox function inside another
      if ( numel( func ) > 7 ) && ( strcmp( func(1:7), '@(u,p)-' ) )
        funcs = [ funcs, {field{i}} ]; %#ok<AGROW>
      else
        funcs = [ funcs, {eval(['@(u,p) -',func,'(u,p)'])} ]; %#ok<AGROW>
      end
    end
  end
  % check if the direction of the flow matches the order of points in x0 -
  % if not change t0 and x0 for convergence
  y = diff(x0([1,2],:));
  y = y/norm(y);
  F = funcs{1}(x0(1,:)',args.p0);
  F = F/norm(F);
  if y*F<0
    t0 = flipud(t0(end)-t0);
    x0 = flipud(x0);
  end
else
  for i = 1:numel(field)
    if isa(field{i}, 'function_handle') 
      funcs = [ funcs, {field{i}} ]; %#ok<AGROW>
    end
  end
end

end