function flqt = flqt_sol_info(sub_type)
%FLQT_SOL_INFO   Construct COLL solution information structure.
%
% FLQT = FLQT_SOL_INFO(SUB_TYPE)
%
% This function is part of the toolbox developers interface and should
% typically not be used directly.
%
% Construct a solution information structure appropriate for the subtype
% passed in SUB_TYPE, which may be omitted or empty to set the branch type
% to 'segs'. There are currently no valid sub types. The solution
% information structure is appended to the ode toolbox information and used
% by FLQT_READ_SOLUTION to determine what information is stored for a
% solution point.
%
% See also: RPP_READ_SOLUTION, ODE_ADD_TB_INFO

% Copyright (C) Frank Schilder, Harry Dankowicz
% Modified function references: James Hannam, Bernd Krauskopf, Hinke M. Osigna
% $Id: flqt_sol_info.m 2020-11-26 14:50 NZDT$

flqt.format = 'flqt.v1';
if nargin<1 || isempty(sub_type)
  flqt.branch_type = 'segs';
else
  flqt.branch_type = [ 'segs.' sub_type ];
end
end
