function [seg1_args, opts] = flqt_init_args(arg_stream)

% extract intial solution data, get function handles; 'reverse time' and
% flip solution to match the flow
grammar   = 'F [DFDX [DFDP [DFDT [DFDXDX [DFDXDP [DFDPDP [DFDTDX [DFDTDP [DFDTDT]]]]]]]]] T0 X0 [PNAMES] P0 [THETA] [OPTS]';
args_spec = {
       'F',     '',     '@',      'fhan', [], 'read', {}
    'DFDX',     '',  '@|[]',   'dfdxhan', [], 'read', {}
    'DFDP',     '',  '@|[]',   'dfdphan', [], 'read', {}
    'DFDT',     '',  '@|[]',   'dfdthan', [], 'read', {}
  'DFDXDX',     '',  '@|[]', 'dfdxdxhan', [], 'read', {}
  'DFDXDP',     '',  '@|[]', 'dfdxdphan', [], 'read', {}
  'DFDPDP',     '',  '@|[]', 'dfdpdphan', [], 'read', {}
  'DFDTDX',     '',  '@|[]', 'dfdtdxhan', [], 'read', {}
  'DFDTDP',     '',  '@|[]', 'dfdtdphan', [], 'read', {}
  'DFDTDT',     '',  '@|[]', 'dfdtdthan', [], 'read', {}
      'T0',     '', '[num]',        't0', [], 'read', {}
      'X0',     '', '[num]',        'x0', [], 'read', {}
  'PNAMES', 'cell', '{str}',    'pnames', {}, 'read', {}
      'P0',     '', '[num]',        'p0', [], 'read', {}
   'THETA',     '', '[num]',     'theta', [], 'read', {}
  };
opts_spec = {
         '-u',       'u', false, 'toggle', {}
  '-flqt_par','flqt_par',    {},   'read', {}
     '-flqt0',   'flqt0',    {},   'read', {}
  };

[args, opts] = coco_parse(grammar, args_spec, opts_spec, arg_stream);

[funcs, t0, x0] = check_funcs(args, opts);

stab = [];  % set '-u' flag for ode_isol2rpp to stable
if opts.u  % set mode for rotation of backward-time linear bundle of periodic orbit
  opts.mode = 1;
  stab = '-u';
else  % set mode for rotation of forward-time linear bundle of periodic orbit
  opts.mode = 2;
end

% set perturbation amplitude to 1 by default
dim = numel(x0(1,:));
% construct arguments to send to ode_isol2coll and initiate variational problem
if isempty(args.theta)
  seg1_args = arg_stream.put(funcs{:}, t0, x0, args.p0, '-var', eye(dim));
else
  % set up the two-sgement floquet boundary conditions such there is
  % continuity across the fixed boundary at x0.seg1: w0.seg1 = w1.seg2,
  % and floquet conditions at the moving boundary
  % x1.seg1: w1.seg1 = mu*w0.seg2.
  % for continuity, as seg1 is grown we require that the initial
  % perturbation w0.seg1 is scaled by mu, since seg1 is intialised as a
  % 'single point' and w0.seg1 must be close to w1.seg1 = mu*w0.seg2 at the
  % next continuation step
  if ~isempty(opts.flqt_par)
    arg_stream.put(opts.flqt_par{1}); %#ok<USENS>
  end
  % set intial perturbations for the variational equations given data.mode
  % defined above
  switch opts.mode
    case 1  % var0 = { w; w } - initial solution has w(0) start at x0.seg2
      var0 = { opts.flqt0{2}; opts.flqt0{2} };
    case 2  % var0 = { mu * w; w } - initial solution has w(0) start at x0.seg1
      var0 = { opts.flqt0{1} * opts.flqt0{2}; opts.flqt0{2} };
  end
  seg1_args = arg_stream.put(funcs{:}, t0, x0, args.pnames, args.p0,...
      args.theta, '-var0', var0, stab);
end

opts.pnames = args.pnames;
opts.theta  = args.theta;

end

function [ funcs, t0, x0 ] = check_funcs( args, opts )

% reverse time to stabalise and unstable periodic orbit - F->-F, t0->flip(t0-T), x0->flip(x0)
x0    = args.x0;
t0    = args.t0;
funcs ={};    % initialise function holder
field =struct2cell(args);
if opts.u    % stabalise the unstable periodic orbit
  for i = 1:numel(field)
    if isa(field{i}, 'function_handle')
      func  = func2str(field{i});    % reconstruct function handle for clarity
      % prevent double reversing the flow when calling iscrn toolbox function inside another
      if ( numel( func ) > 7 ) && ( strcmp( func(1:7), '@(u,p)-' ) )
        funcs = [ funcs, {field{i}} ]; %#ok<AGROW>
      else
        funcs = [ funcs, {eval(['@(u,p) -',func,'(u,p)'])} ]; %#ok<AGROW>
      end
    end
  end
  % check if the direction of the flow matches the order of points in x0 -
  % if not change t0 and x0 for convergence
  y = diff(x0([1,2],:));
  y = y/norm(y);
  F = funcs{1}(x0(1,:)',args.p0);
  F = F/norm(F);
  if y*F<0
    t0 = flipud(t0(end)-t0);
    x0 = flipud(x0);
  end
else
  for i = 1:numel(field)
    if isa(field{i}, 'function_handle')
      funcs = [ funcs, {field{i}} ]; %#ok<AGROW>
    end
  end
end

end
