function J = tube_DFDX(u, p)
%Tube   

x = u(1,:);
y = u(2,:);

a  = p(1,:);
b  = p(2,:);
c  = p(3,:);
d  = p(4,:);
mu = p(5,:);

xy = x .* y;
r2 = x .^2 + y .^2 ; 

J(1,1,:) = mu .* a - b .* (r2 + 2 * x .^2);
J(1,2,:) = -1 - 2 * b .* xy;
J(2,1,:) = 1 - 2 * (b + d) .* xy;
J(2,2,:) = mu .* (a + c) - (b + d) .* (r2 + 2 * y .^2);

end