function J = tube_DFDP(u, p)
%Tube   

x = u(1,:);
y = u(2,:);

a  = p(1,:);
b  = p(2,:);
c  = p(3,:);
d  = p(4,:);
mu = p(5,:);

r2 = x .^2 + y .^2;

J(1,1,:) = mu .* x;
J(1,2,:) = -x .* r2;
J(1,3,:) = 0;
J(1,4,:) = 0;
J(1,5,:) = a .* x;
J(2,1,:) = mu .* y;
J(2,2,:) = -y .* r2;
J(2,3,:) = mu .* y;
J(2,4,:) = -y .* r2;
J(2,5,:) = (a + c) .* y;

end