function Y = tube(u, p)
%Tube

x = u(1,:);
y = u(2,:);

a  = p(1,:);
b  = p(2,:);
c  = p(3,:);
d  = p(4,:);
mu = p(5,:);

r2 = x .^2 + y .^2;

Y(1,:) = mu .* a .* x -y - b .* x .* r2;
Y(2,:) = x + mu .* (a + c) .* y - (b + d) .* y .* r2;

end
