%% PLotting isochron foliations
%
% The following code plots the isochron foliations for the stable periodic
% orbit and unstable equilibrium in region D, as described in Isochron
% Foliations and bifurcations. We assume that the sccript
% isochron_foliation.m has been used to compute these isochron foliations,
% with the names po/iscrn and ep/iscrn used for the foliations of isochrons
% for the periodic orbit and equilibrium, respectively. 

% PO: Gs
GsP = iscrn_read_foliation('po/iscrn%02d/arc%01d+', 'T%d', {'x0_1', 'x0_2'},...
  '-trunc', 'initial');
GsM = iscrn_read_foliation('po/iscrn%02d/arc%01d-', 'T%d', {'x0_1', 'x0_2'},...
  '-trunc', 'initial');

figure(1)
plot(GsP(1).xpo(:,1), GsP(1).xpo(:,2), 'k')
hold on
for i = 1:length(GsP)
  plot(GsP(i).iscrn(:,1), GsP(i).iscrn(:,2),...
    'Color', iscrn_map_forward((i - 1) / length(GsP)))
  plot(GsM(i).iscrn(:,1), GsM(i).iscrn(:,2),...
    'Color', iscrn_map_forward((i - 1) / length(GsM)))
end
xlabel('x')
ylabel('y', 'rotation', 0)
cmpf = iscrn_map_forward(0:1/100:0.99);
colormap(cmpf)
colorbar('Location', 'SouthOutside')

% EP: q
qPP = iscrn_read_foliation('ep/iscrn%02d/arc%01d+', 'T%d', {'x0_1', 'x0_2'},...
  '-trunc', 'initial');

figure(2)
plot(qPP(1).xpo(:,1), qPP(1).xpo(:,2), 'k')
hold on
for i = 1:length(qPP)
  plot(qPP(i).iscrn(:,1), qPP(i).iscrn(:,2),...
    'Color', iscrn_map_backward((i - 1) / length(qPP)))
end
xlabel('x')
ylabel('y', 'rotation', 0)
cmpb = iscrn_map_backward(0:1/100:0.99);
colormap(cmpb)
colorbar('Location', 'SouthOutside')